// Autor: Mislav Balunovic

#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <queue>

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR (i, 0, n)
#define _ << " _ " <<
#define TRACE(x) cerr << #x << " = " << x << endl
#define debug(...) fprintf(stderr, __VA_ARGS__)
//#define debug
//#define TRACE(x)

using namespace std;

typedef long long llint;

const int MAXN = 500010;

int n, curr, fin[MAXN], id_word[MAXN], nxt_word, bio[MAXN], cookie;
char s[MAXN];
queue<int> q, q_tmp;
vector<int> e[MAXN];
string sol, dp[MAXN];

int main(void) {
  scanf("%s",s);
  n = (int)strlen(s);
  fin[n] = 1;
  id_word[n] = -1;

  for (int i = n - 1; i >= 0; --i) {
    if (s[i] == '|') {
      if (i + 1 < n && isalpha(s[i + 1])) {
	curr = 0;
	++nxt_word;
      }
      ++curr;
    } else {
      id_word[i] = nxt_word;
      int k = i + 2 * curr + 1;
      if (k == n || (k < n && isalpha(s[k]) && id_word[k] == id_word[i] - 1))
	e[i].push_back(k);
      if (i + 1 == n || isalpha(s[i + 1]))
	e[i].push_back(i + 1);
      
      for (int j : e[i]) {
	fin[i] |= fin[j];
      }
    }
  }


  int start = isalpha(s[0]) ? 0 : 2 * curr;
  q.push(start);
  assert(fin[start]);
  sol += s[start];

  while(true) {
    ++cookie;
    char best_chr = 'z' + 1;

    while (!q.empty()) {
      int x = q.front();
      q.pop();

      for (int y : e[x]) {
	if (y == n) {
	  cout << sol << endl;
	  return 0;
	}
	if (fin[y] && s[y] <= best_chr && bio[y] != cookie) {
	  bio[y] = cookie;
	  best_chr = s[y];
	  q_tmp.push(y);
	}
      }
    }

    sol += best_chr;
    for(; !q_tmp.empty(); q_tmp.pop())
      if (s[q_tmp.front()] == best_chr) 
	q.push(q_tmp.front());
  }

  return 0;
}
